#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BusinessObjectPropertyComparerBase : BaseTest 
	{
		private class MockBusinessObject
		{
			public readonly int ValueToCompare;

			public MockBusinessObject( int valueToCompare )
			{
				ValueToCompare = valueToCompare;
			}			
		}

		private class MockBusinessObjectComparer : BOL.BusinessObjectPropertyComparerBase
		{
			protected override int CompareProperties(object x, object y)
			{
				return ((MockBusinessObject)x).ValueToCompare.CompareTo( ((MockBusinessObject)y).ValueToCompare );
			}
		}

		private MockBusinessObjectComparer _testComparer;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_testComparer = new MockBusinessObjectComparer();
		}

		[TearDown]
		protected void TearDown()
		{
			_testComparer = null;
		}

		[Test]
		public void Compare_Pass_1()
		{
			Assert.AreEqual( 0, _testComparer.Compare( null, null ) );
		}
		
		[Test]
		public void Compare_Pass_2()
		{
			Assert.AreEqual( -1, _testComparer.Compare( null, new MockBusinessObject( 1 ) ) );
		}

		[Test]
		public void Compare_Pass_3()
		{
			Assert.AreEqual( 1, _testComparer.Compare( new MockBusinessObject( -1 ), null ) );
		}

		[Test]
		public void Compare_Pass_4()
		{
			Assert.AreEqual( 0, _testComparer.Compare( new MockBusinessObject( 1 ), new MockBusinessObject( 1 ) ) );
		}

		[Test]
		public void Compare_Pass_5()
		{
			Assert.AreEqual( -1, _testComparer.Compare( new MockBusinessObject( -1 ), new MockBusinessObject( 1 ) ) );
		}

		[Test]
		public void Compare_Pass_6()
		{
			Assert.AreEqual( 1, _testComparer.Compare( new MockBusinessObject( 1 ), new MockBusinessObject( -1 ) ) );
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Compare_Fail(){}
	}
}

#endif
